<?php 
include('authentication.php');
include('includes/header.php');
include('includes/topbar.php');
include('includes/sidebar.php');
?>


<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Warranty Register</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">Warranty Register</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">


                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Warranty Register List</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>S No.</th>
                                        <th>Customer Name</th>
                                        <th>Customer Number</th>
                                        <th>Serial No.</th>
                                        <th>Warranty Register By</th>
                                        <th>Status</th>
                                        <th>Created At</th>
                                        <th>Bill Image</th>
                                        <th>Warranty Sticker</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                        $i = 1;
                        $ref = "Warranty Register/";
                        $fetchdata = $database->getReference($ref)->getValue();
                        if($fetchdata>0){
                            foreach ($fetchdata as $key => $row) {
                                ?>
                                    <tr>
                                        <td><?=$i?></td>
                                        <td><?=$row['name']?></td>
                                        <td><?=$row['number']?></td>
                                        <td><?=$row['serial_no']?></td>
                                        <td><?php 
                                        if(isset($row['uid'])){
                                            $uid = $row['uid'];
                                             $ref1 = "RSA/$uid/";
                                            $fetchdata1 = $database->getReference($ref1)->getValue();
                                            echo($fetchdata1['number']);
                                        }else{
                                              echo($row['number']);
                                        }
                                        
                                        ?></td>
                                        <td><?=$row['status']?></td>    
                                        
                                        <td><?php echo date('d/m/Y', $row['created_at']/1000); ?></td>
                                        <?php 
                                             $expiresAt = new \DateTime('tomorrow');
                                            $image1 =  $bucket->object('Mattress_Warranty/'.$row['serial_no'].'/'.'Bill')->signedUrl($expiresAt);
                                            
                                             $expiresAt = new \DateTime('tomorrow');
                                            $image2 =  $bucket->object('Mattress_Warranty/'.$row['serial_no'].'/'.'Warranty_sticker')->signedUrl($expiresAt);
                                        ?>
                                        <td><a href="<?=$image1?>" ><img src="<?=$image1?>" width="100px" height="100px" ></a></td>
                                        <td><a href="<?=$image2?>" ><img src="<?=$image2?>" width="100px" height="100px" ></a></td>
                                        <td>
                                            <form action="code.php" method="post">
                                                <select name="status" id="status" class="form-control" required>
                                                    <option <?php if($row['status'] == 'Pending'){echo('selected');} ?>>Pending</option>
                                                    <option <?php if($row['status'] == 'Approved'){echo('selected');} ?>>Approved</option>
                                                    <option <?php if($row['status'] == 'Rejected'){echo('selected');} ?>>Rejected</option>
                                                </select>
                                                <button type="submit" name="update_warranty_status" class="btn btn-primary mt-3" value="<?=$key?>">Submit</button>
                                            </form>
                                        </td>
                                    </tr>
                                    <?php
                                    $name = "";
                                $i++;
                            }
                        }else{

                        }
                      
                      ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                       <th>S No.</th>
                                        <th>Customer Name</th>
                                        <th>Customer Number</th>
                                        <th>Serial No.</th>
                                        <th>Warranty Register By</th>
                                        <th>Status</th>
                                        <th>Created At</th>
                                        <th>Bill Image</th>
                                        <th>Warranty Sticker</th>
                                        <th>Action</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>


<?php
include('includes/script.php');
?>
<script>
$(document).ready(function() {
    $('.delete_btn').click(function(e) {
        e.preventDefault();
        var id = $(this).closest('tr').find('.id').text();
        console.log(id);
        $('#delete_id').val(id);
        $('#modal-danger').modal('show');

    });
});
</script>
<?php
include('includes/footer.php');
?>