<?php 
include('authentication.php');
include('includes/header.php');
include('includes/topbar.php');
include('includes/sidebar.php');
?>

<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h3>Offer Details</h3>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">Offer Details</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <section class="content">
        <?php include('message.php'); ?>
        <div class="container-fluid">

            <?php 
            $ref = 'Offers/'. $_GET['id'].'/';
            $fetchdata = $database->getReference($ref)->getValue();
        ?>



            <div class="card">

                <form action="code.php" method="POST" enctype="multipart/form-data">>
                    <div class="card-body">
                        <div class="card card-primary">
                            <div class="card-header">
                                <h3 class="card-title">Offer Details</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">



                                <img src="<?php $expiresAt = new \DateTime('tomorrow');
                            echo $bucket->object('offer/'.$fetchdata['photo_name'])->signedUrl($expiresAt); ?>"
                                    alt="Aadhar 1" width="200" height="300">
                                <br>

                                <div class="input-group">
                                    <div class="custom-file">
                                        <label for="file-upload" class="custom-file-label" for="photo">Choose Image 1
                                        </label>
                                        <input type="file" id="file-upload" class="custom-file-input" accept="image/*"
                                            name="image1" id="photo" >
                                    </div>
                                </div>

                                <hr>



                                <strong><i class="far fa-file-alt mr-1"></i> Register On </strong>

                                <p class="text-muted"><?php echo(date('d/m/Y',$fetchdata['created_at']))?></p>

                                <hr>

                                <strong><i class="far fa-file-alt mr-1"></i> Name </strong>

                                <div class="form-group mt-3">
                                    <input type="text" name="name" value="<?=$fetchdata['name']?>" placeholder="Name"
                                        class="form-control" required>

                                </div>

                                <hr>

                                <strong><i class="far fa-file-alt mr-1"></i> Points </strong>

                                <div class="form-group mt-3">
                                    <input type="number" name="point" value="<?=$fetchdata['point']?>"
                                        placeholder="Points" class="form-control" required>

                                </div>

                                <hr>

                                <strong><i class="far fa-file-alt mr-1"></i> Prices </strong>

                                <div class="form-group mt-3">
                                    <input type="number" name="price" value="<?=$fetchdata['price']?>"
                                        placeholder="Prices" class="form-control" required>

                                </div>

                                <hr>

                                <strong><i class="far fa-file-alt mr-1"></i> Cash </strong>

                                <div class="form-group mt-3">
                                    <input type="number" name="cash" value="<?=$fetchdata['cash']?>" placeholder="Cash"
                                        class="form-control" required>

                                </div>

                                <hr>

                                <strong><i class="far fa-file-alt mr-1"></i> Status </strong>




                                <input type="hidden" name="id" value="<?=$_GET['id']?>">


                                <div class="input-group mt-3 mb-3">
                                    <select name="select_enable_disable" class="form-control" required>
                                        <option value="accepted"
                                            <?=$fetchdata['status'] == 1 ? ' selected="selected"' : '';?>>Accepted
                                        </option>
                                        <option value="rejected"
                                            <?=$fetchdata['status'] == 0 ? ' selected="selected"' : '';?>>Rejected
                                            </option1>
                                    </select>
                                </div>

                                <button type="submit" name="update_offer_btn"
                                    class="btn btn-info btn-sm float-sm-right">Submit</button>


                            </div>
                            <!-- /.card-body -->
                        </div>

                    </div>
                </form>
            </div>
        </div>


    </section>



</div>


<?php
include('includes/script.php');
include('includes/footer.php');
?>